% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SILO.R
\name{SILOMonthlyRainfall}
\alias{SILOMonthlyRainfall}
\title{Plot a boxplot of monthly rainfall with mean monthly evaporation}
\usage{
SILOMonthlyRainfall(
  SILO,
  evapcol = "Mwet",
  filename = NULL,
  cols = pkg.env$cols
)
}
\arguments{
\item{SILO}{a list of sites with SILO data, as created by SILOLoad()}

\item{evapcol}{name of an evaporation column to plot, defaults to "MWet".}

\item{filename}{optional, filename to write the plot to, including extension. Filename can include full path or sub folders.}

\item{cols}{optional, a vector of colours to use for the plotting}
}
\value{
a ggplot of the monthly rainfall and evaporation.
}
\description{
Plot a boxplot of monthly rainfall with mean monthly evaporation
}
\examples{
 
\dontrun{
X<-SILOLoad(c("24001","24002","24003"),path="./SWTools/extdata")
p<-SILOMonthlyRainfall(X,"Span",cols=c("black","red","#124734"))
}

}
