% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.p.R
\encoding{UTF-8}
\name{matrix.p}
\alias{matrix.p}
\title{Matrix P}
\usage{
matrix.p(comm, phylodist, notification = TRUE)
}
\arguments{
\item{comm}{Community data, with species as columns and sampling units as
rows. This matrix can contain either presence/absence or abundance data.}

\item{phylodist}{Matrix containing phylogenetic distance between species.
Must be a complete matrix (not a diagonal resemblance matrix).}

\item{notification}{Logical argument (TRUE or FALSE) to specify if
notifications for missing observations are to be shown (Default notification =
TRUE).}
}
\value{
\item{matrix.w}{Standardized community matrix, where rows are
communities and columns species. Row totals (communities) = 1.}
\item{matrix.q}{Standardized matrix containing the degree of belonging of
species in relation to each other. Row totals (species) = 1.}
\item{matrix.P}{Phylogeny-weighted species composition matrix. Row totals
(communities) = 1.}
}
\description{
Function to obtain a matrix containing phylogeny-weighted species
composition. For more details, see \code{\link{syncsa}}.
}
\note{
\strong{IMPORTANT}: Species sequence in the community data
matrix MUST be the same as the one in the phylogenetic distance matrix. See
\code{\link{organize.syncsa}}.
}
\examples{
data(ADRS)
matrix.p(ADRS$community, ADRS$phylo)
}
\references{
Pillar, V.D.; Duarte, L.d.S. (2010). A framework for
metacommunity analysis of phylogenetic structure. Ecology Letters, 13,
587-596.
}
\seealso{
\code{\link{syncsa}}, \code{\link{organize.syncsa}}, \code{\link{belonging}},
\code{\link{matrix.t}}, \code{\link{matrix.x}}
}
\author{
Vanderlei Julio Debastiani <vanderleidebastiani@yahoo.com.br>
}
\keyword{SYNCSA}
