% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Get_DB_MIUR.R
\name{Get_DB_MIUR}
\alias{Get_DB_MIUR}
\title{Download the database of Italian public schools buildings}
\source{
\href{https://dati.istruzione.it/opendata/opendata/catalogo/elements1/?area=Edilizia+Scolastica}{Homepage}
}
\usage{
Get_DB_MIUR(
  Year = 2023,
  verbose = TRUE,
  input_Registry = NULL,
  input_AdmUnNames = NULL,
  show_col_types = FALSE
)
}
\arguments{
\item{Year}{Numeric or character value. Reference school year (last available is 2023).
Available in the formats: \code{2023}, \code{"2022/2023"}, \code{202223}, \code{20222023}. \code{2022} by default (other databases are not currently available for 2023).}

\item{verbose}{Logical. If \code{TRUE}, the user keeps track of the main underlying operations. \code{TRUE} by default.}

\item{input_Registry}{Object of class \code{tbl_df}, \code{tbl} and \code{data.frame}.
The school registry corresonding to the year in scope, obtained as output of the  function \code{\link{Get_Registry}}.
If \code{NULL}, it will be downloaded automatically, but not saved in the global environment.
\code{NULL} by default.}

\item{input_AdmUnNames}{Object of class \code{tbl_df}, \code{tbl} and \code{data.frame}.
The ISTAT file including all the codes and all the names of the administrative units for the year in scope, obtained as output of the function \code{\link{Get_AdmUnNames}}.
Only  necessary for school years 2015/16, 2017/18 and 2018/19.
If \code{NULL} and required, it will be downloaded automatically but not saved in the global environment. \code{NULL} by default.}

\item{show_col_types}{Logical. If \code{TRUE}, if the \code{verbose} argument is also \code{TRUE}, the columns of the raw dataset are shown during the download. \code{FALSE} by default.}
}
\value{
An object of class \code{tbl_df}, \code{tbl} and \code{data.frame}. All variables are characters.
}
\description{
This function downloads the School Buildings Open Database provided by the Italian Ministry of Education, University and Research.


It is one of the main sources of information regarding the infrastructure system of public schools in Italy.
For a given year, all available data are downloaded (except for the structural units section, which has a different level of detail) and gathered into a unique dataframe.
}
\details{
This function downloads the raw data; missing observations are not edited; all variables are characters. To edit the output of this function and convert the relevant variables to numeric or Boolean, please \code{\link{Util_DB_MIUR_num}}.
Schools different from primary, middle or high schools are classified as \code{"NR"}. In the example, the data for school year 2022/23 are retrieved.
}
\examples{

\donttest{
  input_DB23_MIUR <- Get_DB_MIUR(2023)

  input_DB23_MIUR[-c(1,4,6,9)]
}


}
