% Generated by roxygen2 (4.0.2): do not edit by hand
\encoding{UTF-8}
\name{bootstrap}
\alias{bootstrap}
\alias{bootstrap.default}
\alias{bootstrap.model}
\title{Method for Bootstrap}
\usage{
bootstrap(x, ...)

\method{bootstrap}{default}(x, nboots = 100, FUN, ...)

\method{bootstrap}{model}(x, ...)
}
\arguments{
\item{x}{is a vector or a fitted model object whose parameters will be used to produce bootstrapped statistics. Model objects are from the class \dQuote{glm} or \dQuote{lm}.}

\item{nboots}{The number of bootstraps.}

\item{FUN}{the statistic to bootstrap, ie., mean, var, cov, etc.}

\item{\dots}{further arguments passed to or used by other methods.}
}
\value{
A list with the \dQuote{alpha} and \dQuote{beta} slots set. Note that \dQuote{alpha} corresponds to ancillary parameters and \dQuote{beta} corresponds to systematic components of the model.
}
\description{
This method is intended to be provides statistical models that support  bootstrapping.

This function is used to estimating standard errors when the distribution is not know.

This method is used to bootstrapping statistical models, typically of class \dQuote{lm} or \dQuote{glm}.
}
\examples{
x = runif(10, 0, 1)
bootstrap(x,FUN=mean)
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}

Daniel Marcelino, \email{dmarcelino@live.com}
}

