% Generated by roxygen2 (4.0.2): do not edit by hand
\encoding{UTF-8}
\name{shift}
\alias{shift}
\title{Lag or Lead Observations}
\usage{
shift(x, id, time, delta = 1)
}
\arguments{
\item{x}{the variable to be lagged or leaded}

\item{id}{the subject or identification variable.}

\item{time}{the time id variable.}

\item{delta}{an integer value (positive or negative) for units to move either backward or forward.}
}
\value{
An object of the same type as \code{x}
}
\description{
Shift function allows one to either lag or lead a column variables in a data frame.
}
\details{
The combination of \code{id} and \code{time} must yelds to a unique identification of the observations.
}
\examples{
data(sheston91)
# lag
sheston91$L.pop <- with(sheston91, shift(x = pop, id = country, time = year, delta = 1) )
head(sheston91)
# lead
 sheston91$pop.L <- with(sheston91, shift(x = pop, id = country, time = year, delta =  -1) )
 head(sheston91)
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}

