% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cv.R
\encoding{UTF-8}
\name{cv}
\alias{cv}
\alias{cv.default}
\title{Pearson's Coefficient of Variation}
\usage{
cv(x, na.rm = TRUE, ...)

\method{cv}{default}(x, na.rm = TRUE, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{na.rm}{A logical value, default is \code{FALSE}}

\item{\dots}{Additional arguements (currently ignored)}
}
\value{
The coefficient of variation.
}
\description{
Computes the absolute \bold{coefficient of variation} \bold{cv} as proposed by Karl Pearson. This coefficient is given by the division of the standard deviation by the mean. As the CV reflects a normalized measure of the dispersion of a given probability distribution, values for \eqn{cv < 1} are considered \dQuote{low-variance}, while those with \eqn{cv > 1} \dQuote{high-variance}.
}
\details{
\eqn{\frac{sd(x)}{mean(x)} = cv}, which is the inverse of signal-to-noise ratio.
}
\examples{
set.seed(51);
x <- sample(100);
cv(x);
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}
\seealso{
\code{\link{se}}, \code{\link{skewness}}, \code{\link{kurtosis}}, \code{\link{winsorize}}, \code{\link{outliers}}
}
\keyword{Exploratory}

