% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MOMENTS.R
\encoding{UTF-8}
\name{Kurtosis}
\alias{Kurtosis}
\title{Compute the Kurtosis}
\usage{
Kurtosis(x, na.rm = FALSE, type = 3)
}
\arguments{
\item{x}{a numeric vector}

\item{na.rm}{a logical value for \code{na.rm}, default is \code{na.rm=FALSE}.}

\item{type}{an integer between 1 and 3 selecting one of the algorithms for computing kurtosis detailed below}
}
\value{
An object of the same type as \code{x}.
}
\description{
Provides three methods for performing kurtosis test.
}
\details{
Kurtosis measures the peakedness of a data distribution. A distribution with zero kurtosis has a shape as the normal curve (mesokurtic, or mesokurtotic). A positive kurtosis has a curve more peaked about the mean and the its shape is narrower than the normal curve (leptokurtic, or leptokurtotic). A distribution with negative kurtosis has a curve less peaked about the mean and the its shape is flatter than the normal curve (platykurtic, or platykurtotic).
}
\note{
To be consistent with classical use of kurtosis in political science analyses, the default \bold{type} is the same equation used in SPSS and SAS, which is the bias-corrected formula: \bold{Type 2:} G_2 = ((n + 1) g_2+6) * (n-1)/(n-2)(n-3). When you set type to 1, the following equation applies: \bold{Type 1:} g_2 = m_4/m_2^2-3. When you set type to 3, the following equation applies: \bold{Type 3:} b_2 = m_4/s^4-3 = (g_2+3)(1-1/n)^2-3. You must have at least 4 observations in your vector to apply this function.

\bold{Skewness} and \bold{Kurtosis} are functions to measure the third and fourth \bold{central moment} of a data distribution.
}
\examples{

w<-sample(4,10, TRUE)
x <- sample(10, 1000, replace=TRUE, prob=w)

Kurtosis(x, type=1)
Kurtosis(x, type=2)
Kurtosis(x)



}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}
\references{
Balanda, K. P. and H. L. MacGillivray. (1988) Kurtosis: A Critical Review. \emph{The American Statistician,} \bold{42(2), pp. 111--119.}
}

