% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sk_esd.R
\name{"sk_esd"}
\alias{"sk_esd"}
\alias{SK.ESD}
\alias{sk_esd}
\title{The Scott-Knott Effect Size Difference (ESD) Test}
\usage{
sk_esd(x, long = FALSE, ...)
}
\arguments{
\item{x}{A wide-format data frame.}

\item{long}{TRUE if the input data is a long-format.}

\item{...}{Optional parameters.}
}
\value{
A sk_esd object.
}
\description{
An enhancement of the Scott-Knott test (which cluster distributions into statistically distinct ranks) that takes effect size into consideration.
}
\examples{
sk <- sk_esd(example)
sk$original  # Original Groups
sk$groups    # Corrected Groups with effect size wise
sk$reverse   # Reversed Groups

sk <- sk_esd(melt(example), long=TRUE) # Example command for a long format

}
\author{
Chakkrit Tantithamthavorn (kla@chakkrit.com)
}

