% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagrams.R
\name{rel_diag_vec}
\alias{rel_diag_vec}
\title{Reliability diagram from vectors of probabilities and observations}
\usage{
rel_diag_vec(discrete_probs, obs, slope_only = FALSE)
}
\arguments{
\item{discrete_probs}{Vector of (rounded) probabilites.}

\item{obs}{Vector of logical observations.}

\item{slope_only}{logical. If set to TRUE, only the slope of the reliability curve is returned}
}
\value{
A gg object.
}
\description{
The probabilities have to be rounded beforehand (see \code{round_probs}), because the diagram draws a point for each level of the probabilities. The diagram includes a histogram indicating
the forecast relative frequency for each probability bin. The diagram shows the reliability curve and the diagonal for reference.
Moreover, it shows a regression line fitted by weighted linear regression where the forecast relative frequencies are used as weights.
A horizontal and vertical line indicate the frequency of observation = TRUE over the entire dataset.
}
\examples{
discrete_probs = seq(0,1,length.out = 5)
obs = c(FALSE,FALSE,TRUE,TRUE,TRUE)
pp = rel_diag_vec(discrete_probs,obs)
if(interactive()) plot(pp)


}
