% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseckw.R
\name{pseckw}
\alias{pseckw}
\title{The cumulative function of the Secant Kumaraswamy Weibull probability distribution.}
\usage{
pseckw(q, a, b, c, lambda, lower = TRUE, log.p = FALSE)
}
\arguments{
\item{q}{Vector of quantiles.}

\item{a}{A parameter.}

\item{b}{B parameter.}

\item{c}{C parameter.}

\item{lambda}{Lambda parameter.}

\item{lower}{logical; if TRUE (default), probabilities are \eqn{P[X \leq x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}
}
\value{
A vector with n observations of the Secant Kumaraswamy Weibull distribution.
}
\description{
The cumulative function of the Secant Kumaraswamy Weibull probability distribution.
}
\examples{
pseckw(0.5, 1, 1, 1, 1,TRUE,FALSE)
pseckw(0.5, 3, 0.5, 2, 2,TRUE,FALSE)
}

