% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotProbs.R
\name{plotProbs}
\alias{plotProbs}
\title{Plots results from the selectSpecies function}
\usage{
plotProbs(result, traits)
}
\arguments{
\item{result}{A saved object from function selectSpecies()}

\item{traits}{A matrix of trait values where traits are columns and rows are species. Maximum of 2 traits.}
}
\value{
2D barplot of probabilities for each species or 3D barplot that illustrates probabilities of species located within a 2D trait space
}
\description{
This function plots results (species probabilities/optimum solutions) from the selectSpecies() function
}
\examples{
### 1 trait constraint with maximum functional diversity and entropy
Spp=5 #S = number of species
trait <- as.matrix(data.frame(trait=c(1:Spp)))
rownames(trait)=c(letters[1:nrow(trait)])
result1 = selectSpecies(t2c=trait, constraints=c(3.5), t2d=trait, obj="QH", capd=FALSE)
plotProbs(result1,trait)

##### 2 traits: Constrain trait X to value 2.5, diversify trait Y
trait.matrix <- as.matrix(cbind(traitX=c(rep(1,3),rep(2,3),rep(3,3)),
                traitY=c(rep(c(1,2,3),3))))
rownames(trait.matrix)=c(letters[1:9])
result2 = selectSpecies(t2c=as.matrix(trait.matrix[,1]),constraints=c(2.5),
          t2d=as.matrix(trait.matrix[,2]),capd=TRUE,obj="QH")
plotProbs(result2,trait.matrix)
}
