% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoboost.R
\name{force.non.inc}
\alias{force.non.inc}
\title{Non increasing post processinng step for selectboost analysis}
\usage{
force.non.inc(object)
}
\arguments{
\item{object}{Numerical matrix. Result of selectboost (autoboost, fastboost, ...).}
}
\value{
A matrix with the results.
}
\description{
Post processes a selectboost analysis.
}
\details{
\code{force.non.inc} returns a vector after ensuring that the proportion of times each variable was
selected is non increasing with respect to the 1-c0 value.
}
\examples{
data(autoboost.res.x)
res.fastboost.force.non.inc <- force.non.inc(autoboost.res.x)

}
\references{
\emph{selectBoost: a general algorithm to enhance the performance of variable selection methods in correlated datasets}, Frédéric Bertrand, Ismaïl Aouadi, Nicolas Jung, Raphael Carapito, Laurent Vallat, Seiamak Bahram, Myriam Maumy-Bertrand, \url{https://arxiv.org/abs/1810.01670}
}
\seealso{
\code{\link{fastboost}}, \code{\link{autoboost}}

Other Selectboost analyse functions: 
\code{\link{plot.selectboost}()},
\code{\link{summary.selectboost}()}
}
\author{
Frederic Bertrand, \email{frederic.bertrand@math.unistra.fr}
}
\concept{Selectboost analyse functions}
