% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/destr.R
\name{destr}
\alias{destr}
\title{De-string Responses}
\usage{
destr(rmat, column, sep)
}
\arguments{
\item{rmat}{A semnetcleaner filtered response matrix}

\item{column}{The column number or name of the stringed response}

\item{sep}{Separating string character (e.g., " ", ".", ",").
Must be input as a character}
}
\value{
A list containing four objects:

\item{rmat}{A response matrix that has been de-stringed}

\item{part}{The row number is supplied for each case that was affected.
This can be used to replicate the de-stringing process and to keep track of changes more generally}

\item{added}{Stringed responses that were added to the response matrix}

\item{removed}{Stringed responses that were removed from the response matrix}
}
\description{
De-string responses after performing \link[SemNetCleaner]{textcleaner}
}
\examples{
#create example stringed responses
stringed <- cbind(rowSums(cbind(rmat[,c(1,2)])),convmat)

#change name to stringed name
colnames(stringed)[1] <- "alligator.ant"

#de-string
convmat <- destr(stringed, 1, ".")

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
