% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dup.match.R
\name{dup.match}
\alias{dup.match}
\title{Detect Duplicate Matches}
\usage{
dup.match(tc.obj, part, target)
}
\arguments{
\item{tc.obj}{A \code{\link[SemNetCleaner]{textcleaner}} object}

\item{part}{Participant ID}

\item{target}{Target response for correcting the change
(see \code{old} argument in \code{\link[SemNetCleaner]{corr.chn}})}
}
\value{
Returns \code{FALSE} for responses that have been identified
twice in either the participant's original responses
(i.e., \code{tc.obj$responses$orig}) or in their changed responses
(i.e., \code{tc.obj$partChanges}). Returns \code{TRUE} if response is not given
}
\description{
A wrapper function for \code{\link[SemNetCleaner]{corr.chn}}.
It returns the opposite values of what the name of the function suggests --
that is, \code{FALSE} for duplicates and \code{TRUE} for non-duplicates
}
\examples{
# Toy example
raw <- open.animals[c(1:10),-c(1,2)]

# Clean and prepocess data
clean <- textcleaner(raw, partBY = "row", dictionary = "animals")

# Check for duplicate match
dup.match(clean, 1, 1)

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
