% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converge.R
\name{converge}
\alias{converge}
\title{Converge Responses}
\usage{
converge(rmat, word, replace)
}
\arguments{
\item{rmat}{Binary response matrix.
A \link[SemNetCleaner]{textcleaner} filtered response matrix}

\item{word}{Character.
Must be column name (characters).
The column name (or number) that be merged \emph{into}.
This column will \emph{remain} in the matrix}

\item{replace}{Character.
Must be column name (characters).
The column name (or number) that should be merged
with the \code{word} column.
This column will be \emph{removed} from the matrix}
}
\value{
The response matrix with the \code{word} column merged
and the \code{replace} column removed
}
\description{
Merge a column of binarized response data with another
}
\examples{
# Toy example
raw <- open.animals[c(1:10),-c(1:3)]

# Clean and prepocess data
clean <- textcleaner(raw, partBY = "row", dictionary = "animals")

# Converge "golden retriever" into response of "lab"
rmat <- converge(clean$binary,"lab","golden retriever")

# "lab" remains will "golden retriever" responses are merged into
# "lab" and "golden retriever" is removed

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
