% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi.word.check.R
\name{multi.word.check}
\alias{multi.word.check}
\title{Multi Word Checker Wrapper}
\usage{
multi.word.check(string, dictionary, tolerance)
}
\arguments{
\item{string}{Character.
A string of words with a \code{length = 1}}

\item{dictionary}{A dictionary to look for word in (see examples).
See \code{\link{SemNetDictionaries}}}

\item{tolerance}{Numeric.
The distance tolerance set for automatic spell-correction purposes.
This function uses the function \code{\link[stringdist]{stringdist}}
to compute the \href{https://en.wikipedia.org/wiki/Damerau-Levenshtein_distance}{Damerau-Levenshtein}
(DL) distance, which is used to determine potential best guesses.

Unique words (i.e., \emph{n} = 1) that are within the (distance) tolerance are
automatically output as \code{\link[SemNetCleaner]{best.guess}} responses, which are then passed through
\code{\link[SemNetCleaner]{word.check.wrapper}}. If there is more than one word
that is within or below the distance tolerance, then these will be provided as potential
options.

The recommended and default distance tolerance is \code{tolerance = 1},
which only spell corrects a word if there is only one word with a DL distance of 1.}
}
\value{
Either a spell-corrected response or the original response
}
\description{
A wrapper function to spell-check responses
that have more than one word in them
}
\examples{
# Returns "guinea pig"
multi.word.check("guinea big", SemNetDictionaries::animals.dictionary, tolerance = 1)

# Returns original response
multi.word.check("cat dog bear fish bull", SemNetDictionaries::animals.dictionary, tolerance = 1)

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
