% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.data.R
\name{read.data}
\alias{read.data}
\title{Read in Common Data File Extensions}
\usage{
read.data(file = file.choose(), header = TRUE, sep = ",", ...)
}
\arguments{
\item{file}{Character.
A path to the file to load.
Defaults to interactive file selection using \code{\link{file.choose}}}

\item{header}{Boolean.
A logical value indicating whether the file contains the
names of the variables as its first line.
If missing, the value is determined from the file format:
header is set to \code{TRUE} if and only if the first row
contains one fewer field than the number of columns}

\item{sep}{Character.
The field separator character.
Values on each line of the file are separated by this character.
If sep = "" (the default for \code{\link{read.table}}) the separator
is a 'white space', that is one or more spaces, tabs, newlines or
carriage returns}

\item{...}{Additional arguments.
Allows for additional arguments to be passed onto
the respective read functions. See documentation in the list below:

\itemize{
\item{.Rdata}
{\code{\link{load}}}
\item{.rds}
{\code{\link{readRDS}}}
\item{.csv}
{\code{\link[utils]{read.table}}}
\item{.xlsx}
{\code{\link[readxl]{read_excel}}}
\item{.xls}
{\code{\link[readxl]{read_excel}}}
\item{.sav}
{\code{\link[foreign]{read.spss}}}
\item{.txt}
{\code{\link[utils]{read.table}}}
\item{.mat}
{\code{\link[R.matlab]{readMat}}}
}}
}
\value{
A data frame containing a representation of the data in the file.
If file extension is ".Rdata", then data will be read to the global environment
}
\description{
A single function to read in common data file extensions.
Note that this function is specialized for reading in text data in the
format necessary for functions in SemNetCleaner

File extensions supported:
\itemize{
\item{.Rdata} \item{.rds} \item{.csv} \item{.xlsx}
\item{.xls} \item{.sav} \item{.txt} \item{.mat}
}
}
\examples{
# Use this example for your data
if(interactive())
{read.data()}

# Example for CRAN tests
## Create test data
test1 <- c(1:5, "6,7", "8,9,10")

## Path to temporary file
tf <- tempfile()

## Create test file
writeLines(test1, tf)

## Read in data
read.data(tf)

# See documentation of respective R functions for specific examples

}
\references{
# R Core Team

R Core Team (2019). R: A language and environment for
statistical computing. R Foundation for Statistical Computing,
Vienna, Austria. URL https://www.R-project.org/.

# readxl

Hadley Wickham and Jennifer Bryan (2019). readxl: Read Excel
Files. R package version 1.3.1.
https://CRAN.R-project.org/package=readxl

# R.matlab

Henrik Bengtsson (2018). R.matlab: Read and Write MAT Files
and Call MATLAB from Within R. R package version 3.6.2.
https://CRAN.R-project.org/package=R.matlab
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
