% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resp2bin.R
\name{resp2bin}
\alias{resp2bin}
\title{Responses to binary matrix}
\usage{
resp2bin(resp)
}
\arguments{
\item{resp}{Response matrix.
A response matrix of verbal fluency or linguistic data}
}
\value{
A list containing objects for each participant and their responses
}
\description{
Converts the response matrix to binary response matrix
}
\examples{
# Toy example
raw <- open.animals[c(1:10),-c(1:3)]

if(interactive())
{
  # Clean and prepocess data
  clean <- textcleaner(open.animals[,-c(1:2)], partBY = "row", dictionary = "animals")

  # Change response matrix to binary response matrix
  binmat <- resp2bin(clean$responses$corrected)
}

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
