% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.R
\name{get_degree_distribution}
\alias{get_degree_distribution}
\title{Get the degree distribution for a network.}
\usage{
get_degree_distribution(network)
}
\arguments{
\item{network}{A network object.}
}
\value{
A vector of length p, containing the degree for each node in the 
network.
}
\description{
Counts the connections to each node within each structure. Note, this
is not the same as the degree distribution from the adjacency matrix
obtained from the network, which collapses the individual structures into
one graph.
}
\examples{
set.seed(13245)
nw <- random_network(10)
deg <- get_degree_distribution(nw) # Degree of each node.
table(deg) # Frequency table of degrees.
# Five nodes have degree 2, three nodes have degree 3, etc.
}
