% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.R
\name{get_network_modules}
\alias{get_network_modules}
\title{Get a list of modules from the network}
\usage{
get_network_modules(network)
}
\arguments{
\item{network}{A 'network' object.}
}
\value{
A list whose length is the number of modules in the network; 
each element is a vector containing the indicies of the nodes
that belong to that module.
}
\description{
Get a list of modules from the network
}
\examples{
set.seed(12345)
# Create a random network of 50 nodes and modules of sizes between 5-20.
nw <- random_network(50, n_modules = 5, min_module_size = 5, 
                     max_module_size = 20, avg_module_size = 10,
                     sd_module_size = 5)
get_network_modules(nw) # Indicies of nodes contained in each module.
}
