% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AAC.R
\name{SequenceAnalysis.AAC}
\alias{SequenceAnalysis.AAC}
\title{SequenceAnalysis.AAC}
\usage{
SequenceAnalysis.AAC(Protein_Sequence, Sequence = TRUE, Groups = 1)
}
\arguments{
\item{Protein_Sequence}{Protein Sequence or Uniprot ID of a sequence}

\item{Sequence}{If False it will get sequence from uniprot}

\item{Groups}{1 for usual 22 groups amino acid composition, 2 for 5 groups (Nonpolar Aliphatic, nonpolar Aromatic, Polar Uncharged, Polar Positively Charged, Polar Negatively Charged), 3 for 6 groups (nonpolar Aliphatic, nonpolar Aromatic, Polar Uncharged, Polar Positively Charged, Polar Negatively Charged, Special cases) and 4 for 8 group (k-means clustering result) amino acid composition.}
}
\value{
Aminio acid composition
}
\description{
Amino Acid Composition
}
\details{
Amino acid Composition is calculated by four different methods: a) Twenty-two independent categories are considered, with one amino acid for each category. b) Five categories (Nonpolar Aliphatic, Nonpolar Aromatic, Polar Uncharged, Polar Positively Charged, Polar Negatively Charged) are considered according to the standard chemical structures of amino acids. c) Six categories (Nonpolar Aliphatic, Nonpolar Aromatic, Polar Uncharged, Polar Positively Charged, Polar Negatively Charged, Special cases) are considered which Cysteine, Selenocysteine, Glycine and Proline are placed in Special cases group. d) Eight categories are clustered via k-means algorithm on Physicochemical index of amino acids.
}
\examples{
SequenceAnalysis.AAC("AKMNAAKMQWYVIGLPCERTDRSCTRQWYVPIG")
SequenceAnalysis.AAC("O15131",Sequence=FALSE)
SequenceAnalysis.AAC("O15131",Sequence=FALSE,Groups=2)
}
\author{
Babak Khorsand
}

