\name{VISF}
\alias{VISF}
\docType{data}
\title{Vis (2009), fuzzy set data}
\description{The \code{VISF} data frame has 25 rows and 4 sets}
\usage{data(VISF)}
\format{
  A data frame with 25 observations on the following 4 sets.
  \describe{
    \item{\code{p}}{a numeric vector. Condition, weak political positions, with parties in government expecting losses at the next election.}
    \item{\code{s}}{a numeric vector. Condition, deteriorating economic situation.}
    \item{\code{r}}{a numeric vector. Condition, government dominated by parties from the right of the political spectrum.}
    \item{\code{u}}{a numeric vector. Outcome, unpopular reform.}
  }
}

\details{Data are used by Vis (2009) to analyze the pursuit of unpopular reforms by governments. Data are fuzzy-sets.}
\references{
Vis, B. (2009) "Government and Unpopular Social Policy Reforms: Biting the Bullet or Steering Clear?", European Journal of Political Research 48, pp. 31-57.

Schneider, C. Q., Wagemann, C. (2012) Set-Theoretic Methods for the Social Sciences, Cambridge University Press: Cambridge.

Schneider, C. Q., Wagemann, C., Quaranta, M. (2012) How To... Use Software for Set-Theoretic Analysis. Online Appendix to "Set-Theoretic Methods for the Social Sciences". Available at \url{www.cambridge.org/schneider-wagemann}
}
\examples{data(VISF)}
\keyword{datasets}
