% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhc.R
\name{rhc}
\alias{rhc}
\title{Random number generation of Higher Criticism (HC) statitic.}
\usage{
rhc(k, n, beta)
}
\arguments{
\item{k}{- number of observations.}

\item{n}{- dimension parameter, i.e. the number of input statitics to construct HC statistic.}

\item{beta}{- search range parameter . Beta must be between 1/n and 1.}
}
\value{
Random number from HC statistics. The length of the result is determined by k for rhc.
}
\description{
Random number generation of Higher Criticism (HC) statitic.
}
\examples{
## Generate a vector of 10 random numbers from HC statistic when n = 100:
rhc(k=10, n=100, beta=1)
}
\references{
1. Hong Zhang, Jiashun Jin and Zheyang Wu. "Distributions and Statistical Power of Optimal
Signal Detection Methods in Finite Samples", submitted.

2. Donoho, David; Jin, Jiashun. "Higher criticism for detecting sparse heterogeneous mixtures". Annals of Statistics 32 (2004).
}
\seealso{
\code{\link{stat.hc}} for the definition of the statistic.
}

