% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_reduction_utilities.R
\name{ICALoad}
\alias{ICALoad}
\title{ICA Gene Loadings Accessor Function}
\usage{
ICALoad(object, dims.use = NULL, genes.use = NULL, use.full = FALSE)
}
\arguments{
\item{object}{Seurat object}

\item{dims.use}{Dimensions to include (default is all stored dims)}

\item{genes.use}{Genes to include (default is all)}

\item{use.full}{Return projected gene loadings (default is FALSE)}
}
\value{
ICA gene loading matrix for given genes and ICs
}
\description{
Pull the ICA gene loadings matrix
}
\examples{
pbmc_small
pbmc_small <- RunICA(pbmc_small, ics.compute = 10, ics.print = 0)
head(ICALoad(pbmc_small))
# Optionally, you can specify subsets of dims or cells to use
ICALoad(pbmc_small, dims.use = 1:5, genes.use = pbmc_small@var.genes[1:5])

}
