% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction.R
\name{WhichCells}
\alias{WhichCells}
\title{Identify cells matching certain criteria}
\usage{
WhichCells(object, ident = NULL, ident.remove = NULL, cells.use = NULL,
  subset.name = NULL, accept.low = -Inf, accept.high = Inf,
  accept.value = NULL, max.cells.per.ident = Inf, random.seed = 1)
}
\arguments{
\item{object}{Seurat object}

\item{ident}{Identity classes to subset. Default is all identities.}

\item{ident.remove}{Indentity classes to remove. Default is NULL.}

\item{cells.use}{Subset of cell names}

\item{subset.name}{Parameter to subset on. Eg, the name of a gene, PC1, a
column name in object@meta.data, etc. Any argument that can be retreived
using FetchData}

\item{accept.low}{Low cutoff for the parameter (default is -Inf)}

\item{accept.high}{High cutoff for the parameter (default is Inf)}

\item{accept.value}{Returns all cells with the subset name equal to this value}

\item{max.cells.per.ident}{Can be used to downsample the data to a certain max per cell ident. Default is inf.}

\item{random.seed}{Random seed for downsampling}
}
\value{
A vector of cell names
}
\description{
Returns a list of cells that match a particular set of criteria such as
identity class, high/low values for particular PCs, ect..
}
\examples{
WhichCells(object = pbmc_small, ident = 2)

}
