% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seurat.R
\docType{class}
\name{seurat}
\alias{seurat}
\alias{seurat-class}
\title{The Seurat Class}
\description{
The Seurat object is the center of each single cell analysis. It stores all information
associated with the dataset, including data, annotations, analyes, etc. All that is needed
to construct a Seurat object is an expression matrix (rows are genes, columns are cells), which
should be log-scale
}
\details{
Each Seurat object has a number of slots which store information. Key slots to access
are listed below.
}
\section{Slots}{

\describe{
\item{\code{raw.data}}{The raw project data}

\item{\code{data}}{The normalized expression matrix (log-scale)}

\item{\code{scale.data}}{scaled (default is z-scoring each gene) expression matrix; used for dimmensional reduction and heatmap visualization}

\item{\code{var.genes}}{Vector of genes exhibiting high variance across single cells}

\item{\code{is.expr}}{Expression threshold to determine if a gene is expressed (0 by default)}

\item{\code{ident}}{THe 'identity class' for each cell}

\item{\code{meta.data}}{Contains meta-information about each cell, starting with number of genes detected (nGene)
and the original identity class (orig.ident); more information is added using \code{AddMetaData}}

\item{\code{project.name}}{Name of hte project (for record keeping)}

\item{\code{dr}}{List of stored dimmensional reductions; named by technique}

\item{\code{assay}}{List of additional assays for multimodal analysis; named by technique}

\item{\code{hvg.info}}{The output of the mean/variability analysis for all genes}

\item{\code{imputed}}{Matrix of imputed gene scores}

\item{\code{cell.names}}{Names of all single cells (column names of the expression matrix)}

\item{\code{cluster.tree}}{List where the first element is a phylo object containing the phylogenetic tree relating different identity classes}

\item{\code{snn}}{Spare matrix object representation of the SNN graph}

\item{\code{calc.params}}{Named list to store all calculation-related parameter choices}

\item{\code{kmeans}}{Stores output of gene-based clustering from \code{DoKMeans}}

\item{\code{spatial}}{Stores internal data and calculations for spatial mapping of single cells}

\item{\code{misc}}{Miscellaneous spot to store any data alongisde the object (for example, gene lists)}

\item{\code{version}}{Version of package used in object creation}
}}

