% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction.R
\name{RenameIdent}
\alias{RenameIdent}
\title{Rename one identity class to another}
\usage{
RenameIdent(object, old.ident.name = NULL, new.ident.name = NULL)
}
\arguments{
\item{object}{Seurat object}

\item{old.ident.name}{The old identity class (to be renamed)}

\item{new.ident.name}{The new name to apply}
}
\value{
A Seurat object where object@ident has been appropriately modified
}
\description{
Can also be used to join identity classes together (for example, to merge
clusters).
}
\examples{
head(x = pbmc_small@ident)
pbmc_small <- RenameIdent(
  object = pbmc_small,
  old.ident.name = 0,
  new.ident.name = 'cluster_0'
)
head(x = pbmc_small@ident)

}
