% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utilities.R
\name{AugmentPlot}
\alias{AugmentPlot}
\title{Augments ggplot2 scatterplot with a PNG image.}
\usage{
AugmentPlot(plot1, imgFile)
}
\arguments{
\item{plot1}{ggplot2 scatterplot. Typically will have only labeled axes and no points}

\item{imgFile}{location of a PNG file that contains the points to overlay onto the scatterplot.}
}
\value{
ggplot2 scatterplot that includes the original axes but also the PNG file
}
\description{
Used in to creating vector friendly plots. Exported as it may be useful to others more broadly
}
\examples{
\dontrun{
data("pbmc_small")
p <- PCAPlot(pbmc_small, do.return = TRUE)
ggsave(filename = 'pcaplot.png', plot = p, device = png)
pmod <- AugmentPlot(plot1 = p, imgFile = 'pcaplot.png')
pmod
}
}
