% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R, R/as.R
\name{Convert}
\alias{Convert}
\alias{Convert.seurat}
\alias{Convert.SingleCellExperiment}
\alias{Convert.anndata.base.AnnData}
\alias{as.seurat}
\alias{as.seurat.SingleCellExperiment}
\alias{as.SingleCellExperiment}
\alias{as.SingleCellExperiment.seurat}
\title{Convert Seurat objects to other classes and vice versa}
\usage{
Convert(from, ...)

\method{Convert}{seurat}(from, to, filename, chunk.dims = "auto",
  chunk.size = 1000, overwrite = FALSE, display.progress = TRUE,
  anndata.raw = "raw.data", anndata.X = "data", ...)

\method{Convert}{SingleCellExperiment}(from, to, raw.data.slot = "counts",
  data.slot = "logcounts", ...)

\method{Convert}{anndata.base.AnnData}(from, to, X.slot = "scale.data",
  raw.slot = "data", ...)

as.seurat(from)

\method{as.seurat}{SingleCellExperiment}(from)

as.SingleCellExperiment(from)

\method{as.SingleCellExperiment}{seurat}(from)
}
\arguments{
\item{from}{Object to convert from}

\item{...}{Arguments passed to and from other methods}

\item{to}{Class of object to convert to}

\item{filename}{Filename for writing files}

\item{chunk.dims}{Internal HDF5 chunk size}

\item{chunk.size}{Number of cells to stream to loom file at a time}

\item{overwrite}{Overwrite existing file at \code{filename}?}

\item{display.progress}{Display a progress bar}

\item{anndata.raw}{Name of matrix (raw.data, data) to put in the anndata raw slot}

\item{anndata.X}{Name of matrix (data, scale.data) to put in the anndata X slot}

\item{raw.data.slot}{name of the SingleCellExperiment assay to slot into @raw.data}

\item{data.slot}{name of the SingleCellExperiment assay to slot into @data}

\item{X.slot}{Seurat slot to transfer anndata X into. Default is scale.data}

\item{raw.slot}{Seurat slot to transfer anndata raw into. Default is data}
}
\value{
An object of class \code{to}
}
\description{
Currently, we support direct conversion to/from loom (\url{http://loompy.org/}),
SingleCellExperiment (\url{https://bioconductor.org/packages/release/bioc/html/SingleCellExperiment.html}),
and Anndata(\url{https://anndata.readthedocs.io/en/latest/}) objects.
}
\section{Methods (by class)}{
\itemize{
\item \code{seurat}: Convert a Seurat object

\item \code{SingleCellExperiment}: Convert from SingleCellExperiment to a Seurat object

\item \code{anndata.base.AnnData}: from Anndata file to a Seurat object
}}

