% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction.R
\name{MergeSeurat}
\alias{MergeSeurat}
\title{Merge Seurat Objects}
\usage{
MergeSeurat(object1, object2, project = NULL, min.cells = 0,
  min.genes = 0, is.expr = 0, do.normalize = TRUE, scale.factor = 10000,
  do.scale = FALSE, do.center = FALSE, names.field = 1,
  names.delim = "_", add.cell.id1 = NULL, add.cell.id2 = NULL)
}
\arguments{
\item{object1}{First Seurat object to merge}

\item{object2}{Second Seurat object to merge}

\item{project}{Project name (string)}

\item{min.cells}{Include genes with detected expression in at least this
many cells}

\item{min.genes}{Include cells where at least this many genes are detected}

\item{is.expr}{Expression threshold for 'detected' gene}

\item{do.normalize}{Normalize the data after merging. Default is TRUE.
If set, will perform the same normalization strategy as stored for the first object}

\item{scale.factor}{If normalizing on the cell level, this sets the scale factor.}

\item{do.scale}{In object@scale.data, perform row-scaling (gene-based
z-score). FALSE by default, so run ScaleData after merging.}

\item{do.center}{In object@scale.data, perform row-centering (gene-based
centering). FALSE by default}

\item{names.field}{For the initial identity class for each cell, choose this
field from the cell's column name}

\item{names.delim}{For the initial identity class for each cell, choose this
delimiter from the cell's column name}

\item{add.cell.id1}{String passed to \code{\link{RenameCells}} for object1}

\item{add.cell.id2}{String passed to \code{\link{RenameCells}} for object1}
}
\value{
Merged Seurat object
}
\description{
Merge two Seurat objects
}
\examples{
# Split pbmc_small for this example
pbmc1 <- SubsetData(object = pbmc_small, cells.use = pbmc_small@cell.names[1:40])
pbmc1
pbmc2 <- SubsetData(object = pbmc_small, cells.use = pbmc_small@cell.names[41:80])
pbmc2
# Merge pbmc1 and pbmc2 into one Seurat object
pbmc_merged <- MergeSeurat(object1 = pbmc1, object2 = pbmc2)
pbmc_merged

}
