% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction.R
\name{SubsetByPredicate}
\alias{SubsetByPredicate}
\title{Return a subset of the Seurat object.}
\usage{
SubsetByPredicate(object, vars.use, predicate)
}
\arguments{
\item{object}{Seurat object}

\item{vars.use}{Variables to fetch for use in base::subset. Character vector.}

\item{predicate}{String to be parsed into an R expression and evaluated as an input to base::subset.}
}
\description{
Creates a Seurat object containing only a subset of the cells in the
original object. Forms a dataframe by fetching the variables in \code{vars.use}, then
subsets it using \code{base::subset} with \code{predicate} as the filter.
Returns the corresponding subset of the Seurat object.
}
\examples{
pbmc1 <- SubsetByPredicate(object = pbmc_small,
                      vars.use = c("nUMI", "res.1"),
                      predicate = "nUMI < 200 & res.1=='3'")
pbmc1

}
