% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_validation.R
\name{AssessSplit}
\alias{AssessSplit}
\title{Assess Cluster Split}
\usage{
AssessSplit(object, node, cluster1, cluster2, genes.training = NULL,
  print.output = TRUE, ...)
}
\arguments{
\item{object}{Seurat object}

\item{node}{Node in the cluster tree in question}

\item{cluster1}{First cluster to compare}

\item{cluster2}{Second cluster to compare}

\item{genes.training}{A vector of genes to use to train the classifier,
defaults to \code{rownames(x = object@data)}}

\item{print.output}{Print the OOB error for the classifier}

\item{...}{Arguments passed on to \code{BuildRFClassifier}
\describe{
  \item{training.genes}{Vector of genes to build the classifier on}
  \item{training.classes}{Vector of classes to build the classifier on}
  \item{verbose}{Additional progress print statements}
}}
}
\value{
Returns the Out of Bag error for a random forest classifier
trained on the split from the given node
}
\description{
Method for determining confidence in specific bifurcations in
the cluster tree. Use the Out of Bag (OOB) error of a random
forest classifier to judge confidence.
}
\examples{
pbmc_small
pbmc_small <- FindClusters(object = pbmc_small, reduction.type = "pca",
                           dims.use = 1:10, resolution = 1.1, save.SNN = TRUE)
pbmc_small <- BuildClusterTree(pbmc_small, reorder.numeric = TRUE, do.reorder = TRUE)
# Assess based on a given node
AssessSplit(pbmc_small, node = 11)
# Asses based on two given clusters (or vectors of clusters)
AssessSplit(pbmc_small, cluster1 = 5, cluster2 = 6)
AssessSplit(pbmc_small, cluster1 = 4, cluster2 = c(5, 6))

}
