% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{CreateSeuratObject}
\alias{CreateSeuratObject}
\title{Create a Seurat object}
\usage{
CreateSeuratObject(counts, project = "SeuratProject", assay = "RNA",
  min.cells = 0, min.features = 0, names.field = 1,
  names.delim = "_", meta.data = NULL)
}
\arguments{
\item{counts}{Unnormalized data such as raw counts or TPMs}

\item{project}{Sets the project name for the Seurat object.}

\item{assay}{Name of the assay corresponding to the initial input data.}

\item{min.cells}{Include features detected in at least this many cells. Will
subset the counts matrix as well. To reintroduce excluded features, create a
new object with a lower cutoff.}

\item{min.features}{Include cells where at least this many features are
detected.}

\item{names.field}{For the initial identity class for each cell, choose this field from the
cell's name. E.g. If your cells are named as BARCODE_CLUSTER_CELLTYPE in the input matrix, set
names.field to 3 to set the initial identities to CELLTYPE.}

\item{names.delim}{For the initial identity class for each cell, choose this delimiter from the
cell's column name. E.g. If your cells are named as BARCODE-CLUSTER-CELLTYPE, set this to "-" to
separate the cell name into its component parts for picking the relevant field.}

\item{meta.data}{Additional cell-level metadata to add to the Seurat object. Should be a data
frame where the rows are cell names and the columns are additional metadata fields.}
}
\description{
Create a Seurat object from a feature (e.g. gene) expression matrix. The expected format of the
input matrix is features x cells.
}
\details{
Note: In previous versions (<3.0), this function also accepted a parameter to set the expression
threshold for a 'detected' feature (gene). This functionality has been removed to simplify the
initialization process/assumptions. If you would still like to impose this threshold for your
particular dataset, simply filter the input expression matrix before calling this function.
}
\examples{
pbmc_raw <- read.table(
  file = system.file('extdata', 'pbmc_raw.txt', package = 'Seurat'),
  as.is = TRUE
)
pbmc_small <- CreateSeuratObject(counts = pbmc_raw)
pbmc_small

}
