% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R, R/convenience.R
\name{DimPlot}
\alias{DimPlot}
\alias{TSNEPlot}
\alias{PCAPlot}
\alias{ICAPlot}
\alias{UMAPPlot}
\title{Dimensional reduction plot}
\usage{
DimPlot(
  object,
  dims = c(1, 2),
  cells = NULL,
  cols = NULL,
  pt.size = NULL,
  reduction = NULL,
  group.by = NULL,
  split.by = NULL,
  shape.by = NULL,
  order = NULL,
  label = FALSE,
  label.size = 4,
  repel = FALSE,
  cells.highlight = NULL,
  cols.highlight = "#DE2D26",
  sizes.highlight = 1,
  na.value = "grey50",
  combine = TRUE,
  ncol = NULL,
  ...
)

PCAPlot(object, ...)

TSNEPlot(object, ...)

UMAPPlot(object, ...)
}
\arguments{
\item{object}{Seurat object}

\item{dims}{Dimensions to plot, must be a two-length numeric vector specifying x- and y-dimensions}

\item{cells}{Vector of cells to plot (default is all cells)}

\item{cols}{Vector of colors, each color corresponds to an identity class. This may also be a single character
or numeric value corresponding to a palette as specified by \code{\link[RColorBrewer]{brewer.pal.info}}.
By default, ggplot2 assigns colors}

\item{pt.size}{Adjust point size for plotting}

\item{reduction}{Which dimensionality reduction to use. If not specified, first searches for umap, then tsne, then pca}

\item{group.by}{Name of one or more metadata columns to group (color) cells by
(for example, orig.ident); pass 'ident' to group by identity class}

\item{split.by}{Name of a metadata column to split plot by;
see \code{\link{FetchData}} for more details}

\item{shape.by}{If NULL, all points are circles (default). You can specify any
cell attribute (that can be pulled with FetchData) allowing for both
different colors and different shapes on cells}

\item{order}{Specify the order of plotting for the idents. This can be
useful for crowded plots if points of interest are being buried. Provide
either a full list of valid idents or a subset to be plotted last (on top)}

\item{label}{Whether to label the clusters}

\item{label.size}{Sets size of labels}

\item{repel}{Repel labels}

\item{cells.highlight}{A list of character or numeric vectors of cells to
highlight. If only one group of cells desired, can simply
pass a vector instead of a list. If set, colors selected cells to the color(s)
in \code{cols.highlight} and other cells black (white if dark.theme = TRUE);
will also resize to the size(s) passed to \code{sizes.highlight}}

\item{cols.highlight}{A vector of colors to highlight the cells as; will
repeat to the length groups in cells.highlight}

\item{sizes.highlight}{Size of highlighted cells; will repeat to the length
groups in cells.highlight}

\item{na.value}{Color value for NA points when using custom scale}

\item{combine}{Combine plots into a single gg object; note that if TRUE; themeing will not work when plotting multiple features}

\item{ncol}{Number of columns for display when combining plots}

\item{...}{Extra parameters passed on to \code{\link{CombinePlots}}}
}
\value{
A ggplot object
}
\description{
Graphs the output of a dimensional reduction technique on a 2D scatter plot where each point is a
cell and it's positioned based on the cell embeddings determined by the reduction technique. By
default, cells are colored by their identity class (can be changed with the group.by parameter).
}
\note{
For the old \code{do.hover} and \code{do.identify} functionality, please see
\code{HoverLocator} and \code{CellSelector}, respectively.
}
\examples{
DimPlot(object = pbmc_small)
DimPlot(object = pbmc_small, split.by = 'ident')

}
\seealso{
\code{\link{FeaturePlot}} \code{\link{HoverLocator}}
\code{\link{CellSelector}} \code{link{FetchData}}
}
