% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{SeuratTheme}
\alias{SeuratTheme}
\alias{DarkTheme}
\alias{FontSize}
\alias{NoAxes}
\alias{NoLegend}
\alias{NoGrid}
\alias{SeuratAxes}
\alias{SpatialTheme}
\alias{RestoreLegend}
\alias{RotatedAxis}
\alias{BoldTitle}
\alias{WhiteBackground}
\title{Seurat Themes}
\usage{
SeuratTheme()

DarkTheme(...)

FontSize(
  x.text = NULL,
  y.text = NULL,
  x.title = NULL,
  y.title = NULL,
  main = NULL,
  ...
)

NoAxes(..., keep.text = FALSE, keep.ticks = FALSE)

NoLegend(...)

NoGrid(...)

SeuratAxes(...)

SpatialTheme(...)

RestoreLegend(..., position = "right")

RotatedAxis(...)

BoldTitle(...)

WhiteBackground(...)
}
\arguments{
\item{...}{Extra parameters to be passed to \code{theme}}

\item{x.text, y.text}{X and Y axis text sizes}

\item{x.title, y.title}{X and Y axis title sizes}

\item{main}{Plot title size}

\item{keep.text}{Keep axis text}

\item{keep.ticks}{Keep axis ticks}

\item{position}{A position to restore the legend to}
}
\value{
A ggplot2 theme object
}
\description{
Various themes to be applied to ggplot2-based plots
\describe{
  \item{\code{SeuratTheme}}{The curated Seurat theme, consists of ...}
  \item{\code{DarkTheme}}{A dark theme, axes and text turn to white, the background becomes black}
  \item{\code{NoAxes}}{Removes axis lines, text, and ticks}
  \item{\code{NoLegend}}{Removes the legend}
  \item{\code{FontSize}}{Sets axis and title font sizes}
  \item{\code{NoGrid}}{Removes grid lines}
  \item{\code{SeuratAxes}}{Set Seurat-style axes}
  \item{\code{SpatialTheme}}{A theme designed for spatial visualizations (eg \code{\link{PolyFeaturePlot}}, \code{\link{PolyDimPlot}})}
  \item{\code{RestoreLegend}}{Restore a legend after removal}
  \item{\code{RotatedAxis}}{Rotate X axis text 45 degrees}
  \item{\code{BoldTitle}}{Enlarges and emphasizes the title}
}
}
\examples{
# Generate a plot with a dark theme
library(ggplot2)
df <- data.frame(x = rnorm(n = 100, mean = 20, sd = 2), y = rbinom(n = 100, size = 100, prob = 0.2))
p <- ggplot(data = df, mapping = aes(x = x, y = y)) + geom_point(mapping = aes(color = 'red'))
p + DarkTheme(legend.position = 'none')

# Generate a plot with no axes
library(ggplot2)
df <- data.frame(x = rnorm(n = 100, mean = 20, sd = 2), y = rbinom(n = 100, size = 100, prob = 0.2))
p <- ggplot(data = df, mapping = aes(x = x, y = y)) + geom_point(mapping = aes(color = 'red'))
p + NoAxes()

# Generate a plot with no legend
library(ggplot2)
df <- data.frame(x = rnorm(n = 100, mean = 20, sd = 2), y = rbinom(n = 100, size = 100, prob = 0.2))
p <- ggplot(data = df, mapping = aes(x = x, y = y)) + geom_point(mapping = aes(color = 'red'))
p + NoLegend()

# Generate a plot with no grid lines
library(ggplot2)
df <- data.frame(x = rnorm(n = 100, mean = 20, sd = 2), y = rbinom(n = 100, size = 100, prob = 0.2))
p <- ggplot(data = df, mapping = aes(x = x, y = y)) + geom_point(mapping = aes(color = 'red'))
p + NoGrid()

}
\seealso{
\code{\link[ggplot2]{theme}}
}
