% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/preprocessing.R
\name{RunALRA}
\alias{RunALRA}
\alias{RunALRA.default}
\alias{RunALRA.Seurat}
\title{Run Adaptively-thresholded Low Rank Approximation (ALRA)}
\usage{
RunALRA(object, ...)

\method{RunALRA}{default}(
  object,
  k = NULL,
  q = 10,
  quantile.prob = 0.001,
  use.mkl = FALSE,
  mkl.seed = -1,
  ...
)

\method{RunALRA}{Seurat}(
  object,
  k = NULL,
  q = 10,
  quantile.prob = 0.001,
  use.mkl = FALSE,
  mkl.seed = -1,
  assay = NULL,
  slot = "data",
  setDefaultAssay = TRUE,
  genes.use = NULL,
  K = NULL,
  thresh = 6,
  noise.start = NULL,
  q.k = 2,
  k.only = FALSE,
  ...
)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{k}{The rank of the rank-k approximation. Set to NULL for automated choice of k.}

\item{q}{The number of additional power iterations in randomized SVD when
computing rank k approximation. By default, q=10.}

\item{quantile.prob}{The quantile probability to use when calculating threshold.
By default, quantile.prob = 0.001.}

\item{use.mkl}{Use the Intel MKL based implementation of SVD. Needs to be
installed from https://github.com/KlugerLab/rpca-mkl. \strong{Note}: this requires
the \href{https://github.com/satijalab/seurat-wrappers}{SeuratWrappers} implementation
of \code{RunALRA}}

\item{mkl.seed}{Only relevant if \code{use.mkl = TRUE}. Set the seed for the random
generator for the Intel MKL implementation of SVD. Any number <0 will
use the current timestamp. If \code{use.mkl = FALSE}, set the seed using
\code{\link{set.seed}()} function as usual.}

\item{assay}{Assay to use}

\item{slot}{slot to use}

\item{setDefaultAssay}{If TRUE, will set imputed results as default Assay}

\item{genes.use}{genes to impute}

\item{K}{Number of singular values to compute when choosing k. Must be less
than the smallest dimension of the matrix. Default 100 or smallest dimension.}

\item{thresh}{The threshold for ''significance'' when choosing k. Default 1e-10.}

\item{noise.start}{Index for which all smaller singular values are considered noise.
Default K - 20.}

\item{q.k}{Number of additional power iterations when choosing k. Default 2.}

\item{k.only}{If TRUE, only computes optimal k WITHOUT performing ALRA}
}
\description{
Runs ALRA, a method for imputation of dropped out values in scRNA-seq data.
Computes the k-rank approximation to A_norm and adjusts it according to the
error distribution learned from the negative values. Described in
Linderman, G. C., Zhao, J., Kluger, Y. (2018). "Zero-preserving imputation
of scRNA-seq data using low rank approximation." (bioRxiv:138677)
}
\note{
RunALRA and associated functions are being moved to SeuratWrappers;
for more information on SeuratWrappers, please see \url{https://github.com/satijalab/seurat-wrappers}
}
\examples{
pbmc_small
# Example 1: Simple usage, with automatic choice of k.
pbmc_small_alra <- RunALRA(object = pbmc_small)
\dontrun{
# Example 2: Visualize choice of k, then run ALRA
# First, choose K
pbmc_small_alra <- RunALRA(pbmc_small, k.only=TRUE)
# Plot the spectrum, spacings, and p-values which are used to choose k
ggouts <- ALRAChooseKPlot(pbmc_small_alra)
do.call(gridExtra::grid.arrange, c(ggouts, nrow=1))
# Run ALRA with the chosen k
pbmc_small_alra <- RunALRA(pbmc_small_alra)
}

}
\references{
Linderman, G. C., Zhao, J., Kluger, Y. (2018). "Zero-preserving imputation
of scRNA-seq data using low rank approximation." (bioRxiv:138677)
}
\seealso{
\code{\link{ALRAChooseKPlot}}
}
\author{
Jun Zhao, George Linderman
}
