% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{FetchData}
\alias{FetchData}
\title{Access cellular data}
\usage{
FetchData(object, vars, cells = NULL, slot = "data")
}
\arguments{
\item{object}{Seurat object}

\item{vars}{List of all variables to fetch, use keyword 'ident' to pull identity classes}

\item{cells}{Cells to collect data for (default is all cells)}

\item{slot}{Slot to pull feature data for}
}
\value{
A data frame with cells as rows and cellular data as columns
}
\description{
Retreives data (feature expression, PCA scores, metrics, etc.) for a set
of cells in a Seurat object
}
\examples{
pc1 <- FetchData(object = pbmc_small, vars = 'PC_1')
head(x = pc1)
head(x = FetchData(object = pbmc_small, vars = c('groups', 'ident')))

}
