% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\docType{class}
\name{AnchorSet-class}
\alias{AnchorSet-class}
\alias{AnchorSet}
\title{The AnchorSet Class}
\description{
The AnchorSet class is an intermediate data storage class that stores the anchors and other
related information needed for performing downstream analyses - namely data integration
(\code{\link{IntegrateData}}) and data transfer (\code{\link{TransferData}}).
}
\section{Slots}{

\describe{
\item{\code{object.list}}{List of objects used to create anchors}

\item{\code{reference.cells}}{List of cell names in the reference dataset - needed when performing data
transfer.}

\item{\code{reference.objects}}{Position of reference object/s in object.list}

\item{\code{query.cells}}{List of cell names in the query dataset - needed when performing data transfer}

\item{\code{anchors}}{The anchor matrix. This contains the cell indices of both anchor pair cells, the
anchor score, and the index of the original dataset in the object.list for cell1 and cell2 of
the anchor.}

\item{\code{offsets}}{The offsets used to enable cell look up in downstream functions}

\item{\code{anchor.features}}{The features used when performing anchor finding.}

\item{\code{neighbors}}{List containing Neighbor objects for reuse later (e.g. mapping)}

\item{\code{command}}{Store log of parameters that were used}
}}

\concept{objects}
