% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixscape.R
\name{PrepLDA}
\alias{PrepLDA}
\title{Function to prepare data for Linear Discriminant Analysis.}
\usage{
PrepLDA(
  object,
  de.assay = "RNA",
  pc.assay = "PRTB",
  labels = "gene",
  nt.label = "NT",
  npcs = 10,
  verbose = TRUE,
  logfc.threshold = 0.25
)
}
\arguments{
\item{object}{An object of class Seurat.}

\item{de.assay}{Assay to use for selection of DE genes.}

\item{pc.assay}{Assay to use for running Principle components analysis.}

\item{labels}{Meta data column with target gene class labels.}

\item{nt.label}{Name of non-targeting cell class.}

\item{npcs}{Number of principle components to use.}

\item{verbose}{Print progress bar.}

\item{logfc.threshold}{Limit testing to genes which show, on average, at least
X-fold difference (log-scale) between the two groups of cells. Default is 0.25. 
Increasing logfc.threshold speeds up the function, but can miss weaker signals.}
}
\value{
Returns a list of the first 10 PCs from each projection.
}
\description{
This function performs unsupervised PCA on each mixscape class separately and projects each subspace onto all
cells in the data.
}
\concept{mixscape}
