% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot.shapley}
\alias{plot.shapley}
\title{Barplot of Shapley values}
\usage{
\method{plot}{shapley}(
  x,
  subset = NULL,
  chi2.q = 0.99,
  abbrev.var = 3,
  abbrev.obs = 10,
  sort.var = FALSE,
  sort.obs = FALSE,
  plot_md = TRUE,
  md_squared = TRUE,
  rotate_x = TRUE,
  ...
)
}
\arguments{
\item{x}{A list of class \code{shapley}.}

\item{subset}{Either an integer, \code{"chi2"}, or \code{NULL} (default) to select which rows of \code{phi} should be displayed.
If \code{NULL}, all \eqn{n} rows are displayed,
for a single integer the \code{subset} rows with the highest Mahalanobis distance are displayed,
for an integer vector the \code{subset} selected rows are displayed,
and for \code{"chi2"} all outlying rows are displayed (Mahalanobis distance greater than \eqn{\sqrt{}}\code{qchisq(chi2.q,p)}).}

\item{chi2.q}{Quantile, only used if \code{subset == "chi2"}.}

\item{abbrev.var}{Integer. If \code{abbrev.var} \eqn{> 0}, column names are abbreviated using abbreviate with \code{minlenght = abrev.var}.}

\item{abbrev.obs}{Integer. If \code{abbrev.obs} \eqn{> 0}, row names are abbreviated using abbreviate with \code{minlenght = abrev.obs}.}

\item{sort.var}{Logical. If \code{TRUE} (default), variables are sorted according to the  distance}

\item{sort.obs}{Logical. If \code{TRUE} (default), observations are sorted according to their Mahalanobis distance.}

\item{plot_md}{Logical. If \code{TRUE} (default), the Mahalanobis distance will be included in the plot.}

\item{md_squared}{Logical. If \code{TRUE} (default), the squared Mahalanobis distance is plotted otherwise the (not-squared) Mahalanobis distance.}

\item{rotate_x}{Logical. If \code{TRUE} (default), the x-axis labels are rotated.}

\item{...}{Optional arguments passed to methods.}
}
\value{
Returns a barplot that displays the Shapley values (\code{\link{shapley}})for each observation and optionally (\code{plot_md = TRUE})
includes the squared Mahalanobis distance (black bar) and the corresponding (non-)central chi-square quantile (dotted line).
}
\description{
Barplot of Shapley values
}
\examples{
library(MASS)
set.seed(1)
n <- 100; p <- 10
mu <- rep(0,p)
Sigma <- matrix(0.9, p, p); diag(Sigma) = 1
X <- mvrnorm(n, mu, Sigma)
X_clean <- X
X[sample(1:(n*p), 100, FALSE)] <- rep(c(-5,5),50)
call_shapley <- shapley(X, mu, Sigma)
plot(call_shapley, subset = 1:20)
plot(call_shapley, subset = 5, rotate_x = FALSE)
plot(call_shapley, subset = 5, md_squared = FALSE, rotate_x = FALSE)
}
