% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gDisrim.R
\name{gDiscrim}
\alias{gDiscrim}
\title{Generalized Item Discrimination}
\usage{
gDiscrim(x, k = 3, l = 1, u = 3)
}
\arguments{
\item{x}{matrix or data.frame of items to be examined. Rows represent persons, columns
reperesent items.}

\item{k}{numeric: number of groups to which may be data.frame x divided by the total score.
Default value is 3.  See \strong{Details}.}

\item{l}{numeric: lower group. Default value is 1. See \strong{Details}.}

\item{u}{numeric: upper group. Default value is 3. See \strong{Details}.}
}
\description{
Generalized item discrimination functions is generalized version of
\code{\link{discrim}} function from \code{psychometric} package. It computes discrimination of an item,
i.e. the ablitity for a specific items to distinguish among upper and lower ability individuals on a test,
where number of groups, upper and lower group can be specified by user.
}
\details{
The function takes data on individuals, computes their total test score and then divides
individuals into \code{k} groups. The lower and upper group are determined by \code{l} and \code{u}
parameters, i.e.  l-th and u-th group where the ordering is defined by increasing total score.
}
\note{
\code{gDiscrim} is used by \code{\link{DDplot}} function.
}
\examples{
\dontrun{
# loading 100-item medical admission test data set
data(dataMedical)
x <- dataMedical[, 1:100]

# discrimination as in discrim() function from psychometric package
# compare to psychometric::discrim(x)
gDiscrim(x)

# 5 groups, compare 4th and 5th
gDiscrim(x, k = 5, l = 4, u = 5)
}
}
\references{
Martinkova, P., Stepanek, L., Drabinova, A., Houdek, J., Vejrazka, M., & Stuka, C. (2017).
Semi-real-time analyses of item characteristics for medical school admission tests.
In: Proceedings of the 2017 Federated Conference on Computer Science and Information Systems.
}
\seealso{
\code{\link{discrim}}, \code{\link{DDplot}}
}
\author{
Adela Drabinova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
drabinova@cs.cas.cz \cr

Lubos Stepanek \cr
First Faculty of Medicine, Charles University \cr
lubomir.stepanek@lf1.cuni.cz \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
martinkova@cs.cas.cz \cr
}
