% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAdjacent.R
\name{plotAdjacent}
\alias{plotAdjacent}
\title{Plot category probabilities of adjacent category logit model}
\usage{
plotAdjacent(x, matching.name = "matching")
}
\arguments{
\item{x}{object of class \code{vglm}}

\item{matching.name}{character: name of matching criterion used for
estimation in \code{x}.}
}
\value{
An object of class \code{ggplot} and/or \code{gg}.
}
\description{
Function for plotting category probabilities function estimated
  by \code{vglm()} function from the \code{VGAM} package using the
  \pkg{ggplot2} package.
}
\examples{
# loading packages
library(VGAM)

# loading data
data(Science, package = "mirt")

# total score calculation
score <- rowSums(Science)
Science[, 1] <- factor(Science[, 1], levels = sort(unique(Science[, 1])), ordered = TRUE)

# adjacent category logit model for item 1
fit <- vglm(Science[, 1] ~ score, family = acat(reverse = FALSE, parallel = TRUE))
# coefficients for item 1
coef(fit)

plotAdjacent(fit, matching.name = "Total score")
}
\seealso{
\code{\link[VGAM]{vglm}}
}
\author{
Tomas Jurica \cr
Institute of Computer Science of the Czech Academy of Sciences \cr

Adela Hladka \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
