% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/preprocessing.R
\name{RegionStats}
\alias{RegionStats}
\alias{RegionStats.default}
\alias{RegionStats.Assay}
\alias{RegionStats.Seurat}
\title{Compute base composition information for genomic ranges}
\usage{
RegionStats(object, ...)

\method{RegionStats}{default}(object, genome, sep = c("-", "-"), verbose = TRUE, ...)

\method{RegionStats}{Assay}(object, genome, sep = c("-", "-"), verbose = TRUE, ...)

\method{RegionStats}{Seurat}(
  object,
  genome,
  assay = NULL,
  sep = c("-", "-"),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{A Seurat object, Assay object, or set of genomic ranges}

\item{...}{Arguments passed to other methods}

\item{genome}{A BSgenome object}

\item{sep}{A length-2 character vector containing the separators to be used when constructing
genomic coordinates from the regions. The first element is used to separate the chromosome
from the genomic coordinates, and the second element used to separate the start and
end coordinates.}

\item{verbose}{Display messages}

\item{assay}{Name of assay to use}
}
\value{
Returns a dataframe
}
\description{
Compute the GC content, region lengths, and dinucleotide base frequencies
for regions in the assay and add to the feature metadata.
}
\examples{
\donttest{
library(BSgenome.Hsapiens.UCSC.hg19)
RegionStats(object = rownames(atac_small), genome = BSgenome.Hsapiens.UCSC.hg19, sep = c(":", "-"))
}
\donttest{
library(BSgenome.Hsapiens.UCSC.hg19)
RegionStats(object = atac_small[['peaks']], genome = BSgenome.Hsapiens.UCSC.hg19, sep = c(":", "-"))
}
\donttest{
library(BSgenome.Hsapiens.UCSC.hg19)
RegionStats(
  object = atac_small,
  assay = 'bins',
  genome = BSgenome.Hsapiens.UCSC.hg19
)
}
}
