% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/links.R
\name{ConnectionsToLinks}
\alias{ConnectionsToLinks}
\title{Cicero connections to links}
\usage{
ConnectionsToLinks(conns, ccans = NULL, threshold = 0)
}
\arguments{
\item{conns}{A dataframe containing co-accessible elements. This would
usually be the output of \code{run_cicero} or
\code{assemble_connections}. Specifically, this should be a
dataframe where the first column contains the genomic coordinates of the
first element in the linked pair of elements, with chromosome, start, end
coordinates separated by "-" characters. The second column should be the
second element in the linked pair, formatted in the same way as the first
column. A third column should contain the co-accessibility scores.}

\item{ccans}{This is optional, but if supplied should be a dataframe
containing the cis-co-accessibility network (CCAN) information generated
by \code{generate_ccans}. Specifically, this should be a
dataframe containing the name of the peak in the first column, and the
CCAN that it belongs to in the second column.}

\item{threshold}{Threshold for retaining a coaccessible site. Links with
a value less than or equal to this threshold will be discarded.}
}
\value{
Returns a \code{\link[GenomicRanges]{GRanges}} object
}
\description{
Convert the output of Cicero connections to a set of genomic ranges where
the start and end coordinates of the range are the midpoints of the linked
elements. Only elements on the same chromosome are included in the output.
}
\details{
See the Cicero package for more information:
\url{https://bioconductor.org/packages/cicero/}
}
\concept{links}
