% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/motifs.R
\name{RunChromVAR}
\alias{RunChromVAR}
\alias{RunChromVAR.ChromatinAssay}
\alias{RunChromVAR.Seurat}
\title{Run chromVAR}
\usage{
RunChromVAR(object, ...)

\method{RunChromVAR}{ChromatinAssay}(object, genome, motif.matrix = NULL, verbose = TRUE, ...)

\method{RunChromVAR}{Seurat}(
  object,
  genome,
  motif.matrix = NULL,
  assay = NULL,
  new.assay.name = "chromvar",
  ...
)
}
\arguments{
\item{object}{A Seurat object}

\item{...}{Additional arguments passed to
\code{\link[chromVAR]{getBackgroundPeaks}}}

\item{genome}{A BSgenome object}

\item{motif.matrix}{A peak x motif matrix. If NULL, pull the peak x motif
matrix from a Motif object stored in the assay.}

\item{verbose}{Display messages}

\item{assay}{Name of assay to use}

\item{new.assay.name}{Name of new assay used to store the chromVAR results.
Default is "chromvar".}
}
\value{
Returns a \code{\link[Seurat]{Seurat}} object with a new assay
}
\description{
Wrapper to run \code{\link[chromVAR]{chromVAR}} on an assay with a motif
object present. Will return a new Seurat assay with the motif activities
(the deviations in chromatin accessibility across the set of regions) as
a new assay.
}
\details{
See the chromVAR documentation for more information:
\url{https://greenleaflab.github.io/chromVAR/index.html}

See the chromVAR paper: \url{https://www.nature.com/articles/nmeth.4401}
}
\examples{
\dontrun{
library(BSgenome.Hsapiens.UCSC.hg19)
RunChromVAR(object = atac_small[["peaks"]], genome = BSgenome.Hsapiens.UCSC.hg19)
}
\dontrun{
library(BSgenome.Hsapiens.UCSC.hg19)
RunChromVAR(object = atac_small, genome = BSgenome.Hsapiens.UCSC.hg19)
}
}
\concept{motifs}
