% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{MatchRegionStats}
\alias{MatchRegionStats}
\title{Match DNA sequence characteristics}
\usage{
MatchRegionStats(
  meta.feature,
  query.feature,
  features.match = c("GC.percent"),
  n = 10000,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{meta.feature}{A dataframe containing DNA sequence information for
features to choose from}

\item{query.feature}{A dataframe containing DNA sequence information for
features to match.}

\item{features.match}{Which features of the query to match when selecting a
set of regions. A vector of column names present in the feature metadata can
be supplied to match multiple characteristics at once. Default is GC content.}

\item{n}{Number of regions to select, with characteristics matching the query}

\item{verbose}{Display messages}

\item{...}{Arguments passed to other functions}
}
\value{
Returns a character vector
}
\description{
Return a vector if genomic regions that match the distribution of a set of
query regions for any given set of characteristics, specified in the input
\code{meta.feature} dataframe.
}
\details{
For each requested feature to match, a density
distribution is estimated using the \code{\link[stats]{density}} function,
and a set of weights for each feature in the dataset estimated based on the
density distribution. If multiple features are to be matched (for example,
GC content and overall accessibility), a joint density distribution is then
computed by multiplying the individual feature weights. A set of features
with characteristics matching the query regions is then selected using the
\code{\link[base]{sample}} function, with the probability of randomly
selecting each feature equal to the joint density distribution weight.
}
\examples{
metafeatures <- Seurat::GetAssayData(
  object = atac_small[['peaks']], slot = 'meta.features'
)
query.feature <- metafeatures[1:10, ]
features.choose <- metafeatures[11:nrow(metafeatures), ]
MatchRegionStats(
  meta.feature = features.choose,
  query.feature = query.feature,
  features.match = "percentile",
  n = 10
)
}
\concept{motifs}
\concept{utilities}
