% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reSummarise.R
\name{reSummarise}
\alias{reSummarise}
\title{Run a summarise step for results that have been saved to the hard drive}
\usage{
reSummarise(
  summarise,
  dir = NULL,
  files = NULL,
  fixed_objects = NULL,
  bootSE = FALSE,
  boot_draws = 1000L
)
}
\arguments{
\item{summarise}{a summarise function to apply to the read-in files.
See \code{\link{runSimulation}} for details}

\item{dir}{directory pointing to the .rds files to be
read-in that were saved from \code{runSimulation(..., save_results=TRUE)}.
If \code{NULL}, it is assumed the current working directory contains
the .rds files}

\item{files}{(optional) names of files to read-in. If \code{NULL} all files
located within \code{dir} will be used}

\item{fixed_objects}{(optional) see \code{\link{runSimulation}} for details}

\item{bootSE}{logical; perform a non-parametric bootstrap to compute bootstrap standard error
estimates for the respective meta-statistics computed by the \code{Summarise} function?
See \code{\link{runSimulation}} for details}

\item{boot_draws}{number of non-parametric bootstrap draws to sample for the \code{summarise}
function after the generate-analyse replications are collected. Default is 1000}
}
\description{
When \code{runSimulation()} uses the option \code{save_results = TRUE}
the R replication results from the Generate-Analyse functions are
stored to the hard drive. As such, additional summarise components
may be required at a later time, whereby the respective \code{.rds} files
must be read back into R to be summarised. This function performs
the reading of these files, application of a provided summarise function,
and final collection of the respective results.
}
\examples{

\dontrun{

Design <- data.frame(N = c(10, 20, 30))

Generate <- function(condition, fixed_objects = NULL){
    dat <- with(condition, rnorm(N, 10, 5)) # distributed N(10, 5)
    dat
}

Analyse <- function(condition, dat, fixed_objects = NULL){
    ret <- mean(dat) # mean of the sample data vector
    ret
}

\dontrun{
# run the simulation
runSimulation(design=Design, replications=50,
              generate=Generate, analyse=Analyse,
              summarise=NA, save_results=TRUE,
              save_details = list(save_results_dirname='simresults'))

Summarise <- function(condition, results, fixed_objects = NULL){
    ret <- c(mu=mean(results), SE=sd(results))
    ret
}

SimClean('SimDesign-results.rds')

res <- reSummarise(Summarise, dir = 'simresults/')
res

Summarise2 <- function(condition, results, fixed_objects = NULL){
    mean(results)
}

res2 <- reSummarise(Summarise2, dir = 'simresults/')
res2

SimClean('simresults/')
}
}
}
\references{
Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
