% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Attach.R
\name{Attach}
\alias{Attach}
\title{Attach objects for easier reference}
\usage{
Attach(
  ...,
  omit = NULL,
  check = TRUE,
  attach_listone = TRUE,
  RStudio_flags = FALSE
)
}
\arguments{
\item{...}{a comma separated list of \code{data.frame}, \code{tibble}, \code{list},
or \code{matrix} objects containing (column) elements that should be placed in the
current working environment}

\item{omit}{an optional character vector containing the names of objects that should not
be attached to the current environment. For instance, if the objects named 'a' and 'b' should
not be attached then use \code{omit = c('a', 'b')}.
When NULL (default) all objects are attached}

\item{check}{logical; check to see if the function will accidentally replace previously defined
variables with the same names as in \code{condition}? Default is \code{TRUE}, which will avoid
this error}

\item{attach_listone}{logical; if the element to be assign is a list of length one
then assign the first element of this list with the associated name. This generally avoids
adding an often unnecessary list 1 index, such as \code{name <- list[[1L]]}}

\item{RStudio_flags}{logical; print R script output comments that disable flagged
missing variables in RStudio? Requires the form \code{Attach(Design, RStudio_flags=TRUE)} or
in an interactive debugging session \code{Attach(condition, RStudio_flags=TRUE)}}
}
\description{
The behaviour of this function is very similar to \code{\link{attach}},
however it is environment specific, and
therefore only remains defined in a given function rather than in the Global Environment.
Hence, this function is much safer to use than the \code{\link{attach}}, which
incidentally should never be used in your code. This
is useful primarily as a convenience function when you prefer to call the variable names
in \code{condition} directly rather than indexing with \code{condition$sample_size} or
\code{with(condition, sample_size)}, for example.
}
\details{
Note that if you are using RStudio with the \emph{"Warn if variable used has no definition in scope"}
diagnostic flag then using \code{Attach()} will raise suspensions. To suppress such issues,
you can either disable such flags (the atomic solution) or evaluate the following output
in the R console and place the output in your working simulation file.

\code{Attach(Design, RStudio_flags = TRUE)}
}
\examples{

Design <- createDesign(N1=c(10,20),
                       N2=c(10,20),
                       sd=c(1,2))
Design

# does not use Attach()
Generate <- function(condition, fixed_objects = NULL) {
    # condition = single row of Design input (e.g., condition <- Design[1,])
    N1 <- condition$N1
    N2 <- condition$N2
    sd <- condition$sd

    group1 <- rnorm(N1)
    group2 <- rnorm(N2, sd=sd)
    dat <- data.frame(group = c(rep('g1', N1), rep('g2', N2)),
                      DV = c(group1, group2))
    dat
}

# similar to above, but using the Attach() function instead of indexing
Generate <- function(condition, fixed_objects = NULL) {
    Attach(condition) # N1, N2, and sd are now 'attached' and visible

    group1 <- rnorm(N1)
    group2 <- rnorm(N2, sd=sd)
    dat <- data.frame(group = c(rep('g1', N1), rep('g2', N2)),
                      DV = c(group1, group2))
    dat
}

#####################
# NOTE: if you're using RStudio with code diagnostics on then evaluate + add the
# following output to your source file to manually support the flagged variables

Attach(Design, RStudio_flags=TRUE)

# Below is the same example, however with false positive missing variables suppressed
# when # !diagnostics ... is added added to the source file(s)

# !diagnostics suppress=N1,N2,sd
Generate <- function(condition, fixed_objects = NULL) {
    Attach(condition) # N1, N2, and sd are now 'attached' and visible

    group1 <- rnorm(N1)
    group2 <- rnorm(N2, sd=sd)
    dat <- data.frame(group = c(rep('g1', N1), rep('g2', N2)),
                      DV = c(group1, group2))
    dat
}


}
\references{
Chalmers, R. P., & Adkins, M. C.  (2020). Writing Effective and Reliable Monte Carlo Simulations
with the SimDesign Package. \code{The Quantitative Methods for Psychology, 16}(4), 248-280.
\doi{10.20982/tqmp.16.4.p248}

Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\seealso{
\code{\link{runSimulation}}, \code{\link{Generate}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
