% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notifications.R
\name{listAvailableNotifiers}
\alias{listAvailableNotifiers}
\title{List All Available Notifiers}
\usage{
listAvailableNotifiers()
}
\value{
A character vector of class names that have \code{notify.<ClassName>} methods.
}
\description{
Automatically detects all S3 classes that have a specialized \code{notify()} method
  (like \code{notify.MyNotifier}) and prints them as a character vector of class names
  (e.g., \code{"PushbulletNotifier"}, \code{"TelegramNotifier"}).

  Note that only classes defined and loaded at the time you call this function will
  appear. If you just created a new notifier in another file or package, ensure it's
  sourced/loaded first.
}
\examples{
\dontrun{
listAvailableNotifiers()
# [1] "PushbulletNotifier" "TelegramNotifier"
}
}
