% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odd.discrete.sel.coef.R
\name{odd.discrete.sel.coef}
\alias{odd.discrete.sel.coef}
\title{Equation of null coefficient selection}
\usage{
odd.discrete.sel.coef(delta_fun,i_fun,E_res,A_fun,alpha_fun,sel_coef_fun)
}
\arguments{
\item{delta_fun}{Numeric value of the actual effect of a mutation targeting enzyme \code{i_fun}, i.e. \eqn{\delta_i}}

\item{i_fun}{Integer number indicating the enzyme targeted by the mutation}

\item{E_res}{Numeric vector of resident enzyme concentrations}

\item{A_fun}{Numeric vector of activities}

\item{alpha_fun}{Numeric matrix of redistribution coefficients}

\item{sel_coef_fun}{Numeric value of selection coefficient}
}
\value{
A numeric value
}
\description{
\emph{(Utilitary function)}. Gives the result of the equation corresponding to discrete coefficient selection and indirect mutation of E
}
\details{
Gives the result of the equation corresponding to discrete coefficient selection and indirect mutation of E. 
Corresponding equation is \eqn{\sum ( \frac{1}{A_j E_j} (\frac{1}{1 + s} - \frac{E_j}{E_j + \alpha_{ij} \delta_i} ) )}

Null this equation corresponds to search the \eqn{\delta_i} corresponding to the given resident concentrations and selection coefficient.

This function is used to find \eqn{\delta} at bounds of the Range of Neutral Variation, where selection coefficient \emph{s} is equal to \eqn{+/-1/N}.
}
\seealso{
See function \code{\link{alpha_ij}} to compute the redistribution coefficients.
}
